<?php
/**
 * Plugin Name: Graphic Web Design, Inc
 * Plugin URI: http://www.thewebsitesupply.com/wordpress-plugin
 * Description: This plugin automatically runs updates for the security of your Wordpress minor and major core version, plugins, and themes.  It will also email you when a plugin is updated so you can verify that nothing on your website has broken.
 * Version: 1.11
 * Author: Steven Spencer / Graphic Web Design, Inc.
 * Author URI: http://www.thewebsitesupply.com
 */


// Auto Update Plugins and Core
add_filter( 'automatic_updater_disabled', '__return_false' );
add_filter( 'allow_minor_auto_core_updates', '__return_true' );         // Enable minor updates
add_filter( 'allow_major_auto_core_updates', '__return_true' );         // Enable major updates
add_filter( 'auto_update_plugin', '__return_true' );
add_filter( 'auto_update_theme', '__return_true' );
add_filter( 'auto_update_translation', '__return_true' );


// Plugin Updated Notifications
add_action( 'upgrader_process_complete', 'gwd_upgrade_function',10, 2);

function gwd_upgrade_function( $upgrader_object, $options ) {
    $current_plugin_path_name = plugin_basename( __FILE__ );

    if ($options['action'] == 'update' && $options['type'] == 'plugin' ){
       //foreach($options['plugins'] as $each_plugin){
             // .......................... YOUR CODES .............
          	 wp_mail(get_option('gwd_email_to'),'Plugin Updated',print_r($options['plugins'],true));

       //}
    }
}


// Create API Token for App and Set Initial Values
// Activation
function gwd_plugin_activation(){
    do_action( 'gwd_plugin_default_options' );
}
register_activation_hook( __FILE__, 'gwd_plugin_activation' );


// Set default values here
function gwd_plugin_default_values(){

    $api_token = strtoupper(substr(str_replace('www.','',$_SERVER['HTTP_HOST']),0,3)).substr(time(),-4);

    if (get_option('gwd_email_to')) {
      update_option('gwd_email_to', 'security@561apps.com');
    } else {
      add_option('gwd_email_to', 'security@561apps.com');
    }


    if (get_option('gwd_app_token')) {
      update_option('gwd_app_token',$api_token);
    } else {
      add_option('gwd_app_token',$api_token);
    }

}
add_action( 'gwd_plugin_default_options', 'gwd_plugin_default_values' );




// Admin Menu Option
add_action( 'admin_menu', 'gwd_admin_menu' );

function gwd_admin_menu() {
	add_menu_page( 'GWD Manager', 'GWD Manager', 'manage_options', 'graphic-web-design/gwd-admin-page.php', 'gwd_admin_page', 'dashicons-rest-api	', 6  );
}


/**
 * Register and enqueue a custom stylesheet in the WordPress admin.
 */
function gwd_enqueue_custom_admin_style() {
        wp_register_style( 'custom_wp_admin_css', plugin_dir_url( __FILE__ ) . 'graphic-web-design.css', array(), '1.0' );
        wp_enqueue_style( 'custom_wp_admin_css' );
}
add_action( 'admin_enqueue_scripts', 'gwd_enqueue_custom_admin_style' );




// Settings Page
function gwd_admin_page(){

  if( $_POST['updated'] === 'true' ){
      gwd_handle_form();
  }

	?>
	<div class="wrap">
		<h2>Graphic Web Design, Inc.</h2>
		<hr />
		<p>This plugin automatically runs updates for the security of your Wordpress minor and major core version, plugins, and themes.  It will also email you when a plugin is updated so you can verify that nothing on your website has broken.  For more information on setting up the API features for this plugin, please contact us, <a href="mailto:steven@thewebsitesupply.com">steven@thewebsitesupply.com</a></p>

	<?php


  echo '<h1 id="api">API TOKEN: <span>'.get_option('gwd_app_token').'</span></h1>';


  ?>
  <form method="POST">
    <input type="hidden" name="updated" value="true" />
    <?php wp_nonce_field('gwd_update','gwd_form'); ?>
    <table class="form-table">
    <tbody>
        <tr>
            <th><label for="emails">Email to send security updates to</label></th>
            <td><input name="emails" id="emails" type="text" class="regular-text" value="<?php _e(get_option('gwd_email_to')); ?>"/></td>
        </tr>

              </tbody>
    </table>


      <?php
          submit_button();
      ?>
  </form>
  </div>


<?php


}


// Handle Admin Form Submission
function gwd_handle_form() {
        if( ! isset( $_POST['gwd_form'] ) || ! wp_verify_nonce( $_POST['gwd_form'], 'gwd_update' ) ){ ?>
           <div class="error">
               <p>Sorry, your nonce was not correct. Please try again.</p>
           </div> <?php
           exit;
        } else {

              $email = sanitize_email($_POST['emails']);

              update_option( 'gwd_email_to', $email );?>
              <div class="updated">
                  <p>Settings saved!</p>
              </div> <?php

        }
    }