const plugin = require("tailwindcss/plugin");
/** @type {import('tailwindcss').Config} */
module.exports = {
  content: ["*.{html,js}"],
  theme: {
    container: {
      center: true,
      padding: {
        DEFAULT: "15px",
        md: "30px",
      },
    },
    screens: {
      sm: "576px",
      md: "768px",
      lg: "992px",
      xl: "1200px",
      xxl: "1400px"
    },
    extend: {
      colors: {
        primary: {
          DEFAULT: "#cc2531",
          hover: "#f02836",
        },
        lightGrey: "#fbfbfb",
      },
      fontFamily: {
        primary: ["Montserrat", "sans-seri"],
      },
      backgroundImage: {
        heroBg: "url('../images/hero-img.jpg')",
        arrowLeft: "url('../images/arrow-bg.png')",
        selectArrow: "url('../images/select-arrow.png')",
      },
    },
  },
  plugins: [
    plugin(function ({ addBase }) {
      addBase({
        html: { fontSize: "10px" },
      });
    }),
  ],
};
